import asyncio
import json

from pylog.pylogger import PyLogger

from py_pli.pylib import send_msg

from urpc_enum.fancontrolparameter import FanControlParameter
from urpc_enum.systemcontrolparameter import SystemControlParameter

from fleming.common.firmware_util import *


#TODO Switch to Virtual Units. For now it was easier to use the firmware_test script instead.


# The delay in seconds for chaning the output in the tests.
DELAY = 2


status_light_color = {
    'green'     : {'color': 0, 'brightness': SystemControlParameter.StatusLightGreenBrightness},
    'orange'    : {'color': 1, 'brightness': SystemControlParameter.StatusLightOrangeBrightness},
}

async def fmb_fp_light_test():
    """
    Test the button lights and status light of the front panel.
    """
    await send_msg(json.dumps({'result': f"Start FMB Firmware"}))
    await start_firmware('fmb')

    await send_msg(json.dumps({'result': f"Initialize System Control"}))
    sys = get_system_control_endpoint()
    await sys.SetParameter(SystemControlParameter.ButtonLightBrightness, 100, timeout=1)
    await sys.SetParameter(SystemControlParameter.StatusLightGreenBrightness, 100, timeout=1)
    await sys.SetParameter(SystemControlParameter.StatusLightOrangeBrightness, 100, timeout=1)
    await sys.SetParameter(SystemControlParameter.ButtonLightBlinkPeriod,  500, timeout=1)
    await sys.SetParameter(SystemControlParameter.StatusLightBlinkPeriod, 1000, timeout=1)

    await send_msg(json.dumps({'result': f"Testing Front Panel Lights"}))

    for button in range(3):
        await send_msg(json.dumps({'result': f"Button Light {button} at 100%"}))
        await sys.SetButtonLight(button, 1, timeout=1)
        await sys.SetParameter(SystemControlParameter.ButtonLightBrightness, 100, timeout=1)
        await asyncio.sleep(1)
        await send_msg(json.dumps({'result': f"Button Light {button} at 50%"}))
        await sys.SetButtonLight(button, 1, timeout=1)
        await sys.SetParameter(SystemControlParameter.ButtonLightBrightness, 50, timeout=1)
        await asyncio.sleep(1)
        await send_msg(json.dumps({'result': f"Button Light {button} at 0%"}))
        await sys.SetButtonLight(button, 1, timeout=1)
        await sys.SetParameter(SystemControlParameter.ButtonLightBrightness, 0, timeout=1)
        await asyncio.sleep(1)
        await sys.SetButtonLight(button, 0, timeout=1)

    for color_name in status_light_color:
        color = status_light_color[color_name]['color']
        brightness = status_light_color[color_name]['brightness']
        await send_msg(json.dumps({'result': f"Status Light {color_name} at 100%"}))
        await sys.SetStatusLight(color, 1, timeout=1)
        await sys.SetParameter(brightness, 100, timeout=1)
        await asyncio.sleep(1)
        await send_msg(json.dumps({'result': f"Status Light {color_name} at 50%"}))
        await sys.SetStatusLight(color, 1, timeout=1)
        await sys.SetParameter(brightness, 50, timeout=1)
        await asyncio.sleep(1)
        await send_msg(json.dumps({'result': f"Status Light {color_name} at 0%"}))
        await sys.SetStatusLight(color, 1, timeout=1)
        await sys.SetParameter(brightness, 0, timeout=1)
        await asyncio.sleep(1)
        await sys.SetStatusLight(color, 0, timeout=1)
    
    return f"Front Panel Light Test DONE"


button_pressed = [False, False, False]

# Callback function for the button events
async def button_event_callback(number, type):
    global button_pressed
    await send_msg(json.dumps({'result': f"Button {number} was pressed"}))
    if (number < len(button_pressed)):
        button_pressed[number] = True


async def fmb_fp_button_test():
    """
    Test the buttons of the front panel.
    """
    global button_pressed
    for i in range(len(button_pressed)):
        button_pressed[i] = False

    await send_msg(json.dumps({'result': f"Start FMB Firmware"}))
    await start_firmware('fmb')

    await send_msg(json.dumps({'result': f"Initialize System Control"}))
    sys = get_system_control_endpoint()
    if button_event_callback not in sys._SystemControlFunctions__SendButtonEventEvents:
        sys.subscribeSendButtonEvent(button_event_callback)
    await sys.EnableSendButtonEvent(number=0, type=1, holdDelay=0, timeout=1)
    await sys.EnableSendButtonEvent(number=1, type=1, holdDelay=0, timeout=1)
    await sys.EnableSendButtonEvent(number=2, type=1, holdDelay=0, timeout=1)

    await send_msg(json.dumps({'result': f"Testing Front Panel Buttons"}))

    timeout = DELAY * 3

    await send_msg(json.dumps({'result': f"Press each button of the front panel once within the next {timeout} s"}))

    for i in range(timeout * 10):
        if button_pressed[0] and button_pressed[1] and button_pressed[2]:
            return f"Front Panel Button Test PASSED"
        else:
            await asyncio.sleep(0.1)
    
    raise Exception(f"Front Panel Button Test FAILED")

